from __future__ import generators
import plus
import Arenas
import random
import Hazards
import math

class ClawTop(Arenas.SuperArena):
    "Battle it out with your modern marvels on this ancient one!"
    name = "The Pyramid"
    preview = "pyramid/dslpyramid_preview.bmp"
    game_types = ['DEATHMATCH', 'BATTLE ROYAL', 'TEAM MATCH']
    extent = (-13, 13, 14, -14)

    def __init__(self):
        Arenas.SuperArena.__init__(self, "Arenas/Pyramid/pyramid.gmf")
        #plus.Arena.__init__(self, "")
        plus.setBackColor(0,0,0)
        
        fov = 0.015

        self.AddStaticCamera("              Overhead", (0, 50, -63), (1.5708,0), 72*fov)
        self.AddStaticCamera("              Static Cam-1a", (0, 80, -20), (2.1, 0), 25*fov)
        self.AddStaticCamera("              Static Cam-1b", (0, 80, -20), (2.1, 0), 35*fov)
        self.AddStaticCamera("              Static Cam-1c", (0, 80, -20), (2.03, 0), 45*fov)

        self.AddStaticCamera("              Static Cam-2a", (0, 45, -20), (2.4, 0), 35*fov)
        self.AddStaticCamera("              Static Cam-2b", (0, 45, -20), (2.3, 0), 45*fov)

        self.AddWatchCamera("               Watch Cam-1b", (0, 50, -30), (6, 12, 30*fov, 20*fov))
        self.AddWatchCamera("               Watch Cam-1c", (0, 50, -30), (6, 12, 30*fov, 30*fov))
        self.AddWatchCamera("               Watch Cam-1d", (0, 50, -30), (6, 12, 30*fov, 40*fov))
        self.AddWatchCamera("               Watch Cam-1e", (0, 50, -30), (6, 12, 30*fov, 50*fov))

        self.AddWatchCamera("               Watch Cam-2a", (0, 30, -30), (6, 12, 30*fov, 10*fov))
        self.AddWatchCamera("               Watch Cam-2b", (0, 30, -30), (6, 12, 30*fov, 20*fov))
        self.AddWatchCamera("               Watch Cam-2c", (0, 30, -30), (6, 12, 30*fov, 30*fov))
        self.AddWatchCamera("               Watch Cam-2d", (0, 30, -30), (6, 12, 30*fov, 40*fov))
        self.AddWatchCamera("               Watch Cam-2e", (0, 30, -30), (6, 12, 30*fov, 50*fov))

        self.AddWatchCamera("               Watch Cam-1a", (0, 50, -30), (6, 12, 30*fov, 10*fov))

        self.players = ()
        
        
    def Activate(self, on):
        if on: self.players = plus.getPlayers()
        
        Arenas.SuperArena.Activate(self, on)


    def Tick(self):
        # check to see if anyone has been "eliminated" by falling off the tabletop
        for each in self.players:
            if plus.getLocation(each)[1] < 2.5:
                plus.eliminatePlayer(each)

        return Arenas.SuperArena.Tick(self)
        
Arenas.register(ClawTop)
